/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.syncing.ui.wizards;

import com.aptana.ide.core.io.ConnectionPoint;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.syncing.ui.wizards.ImportConnectionsPage;
import com.aptana.syncing.ui.wizards.Messages;
import com.aptana.ui.IDialogConstants;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportConnectionsWizard
extends Wizard
implements IImportWizard {
    private static final String STATE_LOCATION_ROOT = ".metadata/.plugins/";
    private ImportConnectionsPage mainPage;

    public void addPages() {
        this.mainPage = new ImportConnectionsPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        IPath location = this.mainPage.getLocation();
        int connectionCount = 0;
        int siteCount = 0;
        int[] applyToAllAction = new int[]{-1};
        if (this.mainPage.isWorkspaceSelected()) {
            IPath connectionPath = location.append(STATE_LOCATION_ROOT).append("com.aptana.ide.core.io");
            File dir = connectionPath.toFile();
            if (dir.isDirectory() ? (connectionCount = this.loadConnectionPoints(dir, applyToAllAction)) == -1 : (dir = (connectionPath = location.append(STATE_LOCATION_ROOT).append("com.aptana.core.io")).toFile()).isDirectory() && (connectionCount = this.loadConnectionPoints(dir, applyToAllAction)) == -1) {
                return false;
            }
            IPath sitePath = location.append(STATE_LOCATION_ROOT).append("com.aptana.ide.syncing.core");
            dir = sitePath.toFile();
            if (dir.isDirectory()) {
                siteCount = this.loadSiteConnections(dir, applyToAllAction);
            } else {
                sitePath = location.append(STATE_LOCATION_ROOT).append("com.aptana.syncing.core");
                dir = sitePath.toFile();
                if (dir.isDirectory()) {
                    siteCount = this.loadSiteConnections(dir, applyToAllAction);
                }
            }
        } else {
            List<IConnectionPoint> connections = this.validateConnectionsFrom(location, applyToAllAction);
            if (connections == null) {
                return false;
            }
            connectionCount = connections.size();
            List<ISiteConnection> sites = this.validateSitesFrom(location, applyToAllAction);
            siteCount = sites.size();
        }
        final int cCount = connectionCount;
        final int sCount = siteCount;
        UIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)ImportConnectionsWizard.this.getShell(), (String)Messages.ImportConnectionsWizard_Info_Title, (String)MessageFormat.format(Messages.ImportConnectionsWizard_Info_Message, cCount, sCount));
            }
        });
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.ImportConnectionsWizard_Title);
    }

    private int loadConnectionPoints(File dir, int[] applyToAllAction) {
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("connections");
            }
        });
        File file = ImportConnectionsWizard.getLatestFile(files);
        if (file != null) {
            List<IConnectionPoint> acceptedConnections = this.validateConnectionsFrom(Path.fromOSString((String)file.getAbsolutePath()), applyToAllAction);
            if (acceptedConnections == null) {
                return -1;
            }
            return acceptedConnections.size();
        }
        return 0;
    }

    private List<IConnectionPoint> validateConnectionsFrom(IPath filePath, int[] applyToAllAction) {
        IConnectionPoint[] currentPoints;
        int action = 0;
        ArrayList<IConnectionPoint> acceptedConnections = new ArrayList<IConnectionPoint>();
        ArrayList<IConnectionPoint> removedConnections = new ArrayList<IConnectionPoint>();
        List newConnections = CoreIOPlugin.getConnectionPointManager().readConnectionsFrom(filePath);
        HashMap<String, IConnectionPoint> renames = new HashMap<String, IConnectionPoint>();
        HashMap<String, Object> currentNames = new HashMap<String, Object>();
        IConnectionPoint[] iConnectionPointArray = currentPoints = CoreIOPlugin.getConnectionPointManager().getConnectionPoints();
        int n = currentPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionPoint current = iConnectionPointArray[n2];
            currentNames.put(current.getName(), current);
            ++n2;
        }
        for (IConnectionPoint newConnection : newConnections) {
            boolean shouldAdd;
            block12: {
                block13: {
                    shouldAdd = true;
                    if (!currentNames.containsKey(newConnection.getName())) break block12;
                    IConnectionPoint current = (IConnectionPoint)currentNames.get(newConnection.getName());
                    if (!((ConnectionPoint)current).getType().equals(((ConnectionPoint)newConnection).getType())) break block13;
                    action = applyToAllAction[0];
                    if (action == -1) {
                        action = this.promptConflictDialog(newConnection.getName(), applyToAllAction);
                    }
                    switch (action) {
                        case 0: {
                            shouldAdd = true;
                            removedConnections.add(current);
                            ((ConnectionPoint)newConnection).setId(current.getId());
                            break block12;
                        }
                        case 1: {
                            shouldAdd = false;
                            break block12;
                        }
                        case 2: {
                            renames.put(newConnection.getName(), newConnection);
                            break block12;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                renames.put(newConnection.getName(), newConnection);
            }
            if (!shouldAdd) continue;
            acceptedConnections.add(newConnection);
            currentNames.put(newConnection.getName(), newConnection);
        }
        for (IConnectionPoint removed : removedConnections) {
            CoreIOPlugin.getConnectionPointManager().removeConnectionPoint(removed);
        }
        for (IConnectionPoint added : acceptedConnections) {
            CoreIOPlugin.getConnectionPointManager().addConnectionPoint(added);
        }
        Iterator<Object> iterator = renames.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String name = key = (String)iterator.next();
            int count = 1;
            ConnectionPoint point = (ConnectionPoint)renames.get(key);
            while (currentNames.containsKey(name)) {
                name = MessageFormat.format(Messages.ImportConnectionsWizard_Conflict_Renamed, key, count++);
            }
            currentNames.put(name, point);
            point.setName(name);
        }
        return acceptedConnections;
    }

    private int loadSiteConnections(File dir, int[] applyAllAction) {
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("sites");
            }
        });
        File file = ImportConnectionsWizard.getLatestFile(files);
        if (file != null) {
            List<ISiteConnection> newSites = this.validateSitesFrom(Path.fromOSString((String)file.getAbsolutePath()), applyAllAction);
            return newSites.size();
        }
        return 0;
    }

    private static File getLatestFile(File[] files) {
        File latestFile = null;
        long maxNumber = 0L;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String filename = file.getName();
            int index = filename.lastIndexOf(46);
            if (index > -1) {
                try {
                    long number = Long.parseLong(filename.substring(index + 1));
                    if (number > maxNumber) {
                        latestFile = file;
                        maxNumber = number;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return latestFile;
    }

    private List<ISiteConnection> validateSitesFrom(IPath filePath, int[] applyToAllAction) {
        ISiteConnection[] currentPoints;
        int action = 0;
        ArrayList<ISiteConnection> acceptedConnections = new ArrayList<ISiteConnection>();
        ArrayList<ISiteConnection> removedConnections = new ArrayList<ISiteConnection>();
        List newConnections = SyncingPlugin.getSiteConnectionManager().readConnectionsFrom(filePath);
        HashMap<String, ISiteConnection> renames = new HashMap<String, ISiteConnection>();
        HashMap<String, ISiteConnection> currentNames = new HashMap<String, ISiteConnection>();
        ISiteConnection[] iSiteConnectionArray = currentPoints = SyncingPlugin.getSiteConnectionManager().getSiteConnections();
        int n = currentPoints.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteConnection current = iSiteConnectionArray[n2];
            currentNames.put(current.getName(), current);
            ++n2;
        }
        for (ISiteConnection newConnection : newConnections) {
            boolean shouldAdd = true;
            if (currentNames.containsKey(newConnection.getName())) {
                ISiteConnection current = (ISiteConnection)currentNames.get(newConnection.getName());
                action = applyToAllAction[0];
                if (action == -1) {
                    action = this.promptConflictDialog(newConnection.getName(), applyToAllAction);
                }
                switch (action) {
                    case 0: {
                        shouldAdd = true;
                        removedConnections.add(current);
                        break;
                    }
                    case 1: {
                        shouldAdd = false;
                        break;
                    }
                    case 2: {
                        renames.put(newConnection.getName(), newConnection);
                    }
                }
            }
            if (!shouldAdd) continue;
            acceptedConnections.add(newConnection);
            currentNames.put(newConnection.getName(), newConnection);
        }
        for (ISiteConnection removed : removedConnections) {
            SyncingPlugin.getSiteConnectionManager().removeSiteConnection(removed);
        }
        for (ISiteConnection added : acceptedConnections) {
            SyncingPlugin.getSiteConnectionManager().addSiteConnection(added);
        }
        Iterator<Object> iterator = renames.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String name = key = (String)iterator.next();
            int count = 1;
            ISiteConnection point = (ISiteConnection)renames.get(key);
            while (currentNames.containsKey(name)) {
                name = MessageFormat.format(Messages.ImportConnectionsWizard_Conflict_Renamed, key, count++);
            }
            currentNames.put(name, point);
            point.setName(name);
        }
        List sites = SyncingPlugin.getSiteConnectionManager().readConnectionsFrom(filePath);
        return sites;
    }

    private int promptConflictDialog(String name, final int[] applyToAllAction) {
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.ImportConnectionsWizard_Conflict_Title, null, MessageFormat.format(Messages.ImportConnectionsWizard_Conflict_Message, name), 0, new String[]{IDialogConstants.OVERWRITE_LABEL, org.eclipse.jface.dialogs.IDialogConstants.SKIP_LABEL, IDialogConstants.RENAME_LABEL}, 0){

            protected Control createCustomArea(Composite parent) {
                final Button applyToAll = new Button(parent, 32);
                GridData data = new GridData(4, 4, true, true);
                applyToAll.setLayoutData((Object)data);
                applyToAll.setText(Messages.ImportConnectionsWizard_Conflict_LBL_Apply);
                applyToAll.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (applyToAll.getSelection()) {
                            applyToAllAction[0] = 0;
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                return applyToAll;
            }
        };
        int action = dialog.open();
        if (applyToAllAction[0] == -1) {
            applyToAllAction[0] = action;
        }
        return action;
    }
}

